using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ConsoleApplication1
{
    class Telo
    {
        private float x;
        private int v;
        public Telo()
        {
            x = 0;
            v = 1;
        }
        public Telo(float X, int V)
        {
            this.x = X;
            this.v = V;
        }
        public float X
        {
            get { return x; }
            set { x = value; }
        }
        public int V
        {
            get { return v; }
            set { v = value; }
        }
        public float kordinata(float t)
        {
            return (x + v * t);//osnovna fizika
        }
        public static float vreme_preticanja(Telo A, Telo B)//Telo A se nalazi levo (pre) tela B, odnosno (....A--->........B->....)
        {
            if (A.v < B.v) { return -1; }
            else { return ((B.x - A.x) / (A.v - B.v)); }
        }
        public static int arraysort(Telo levo, Telo desno)//Reda od najmanjeg do najveceg x-a!!!
        {
            if (levo.x <= desno.x) { return -1; }
            else { return 1; }
        }
        public static int arraysortV(Telo levo, Telo desno)//Reda od najmanjeg do najveceg x-a!!!
        {
            if (levo.v <= desno.v) { return -1; }
            else { return 1; }
        }
        public static Telo[] niz_create(int N)
        {
            Telo[] niz = new Telo[N];
            int c = N;
            while (c > 0)
            {
                string[] xv = Console.ReadLine().Split(' ');
                int x = int.Parse(xv[0]); int v = int.Parse(xv[1]);
                niz[N - c] = new Telo(x, v);
                c--;
            }
            Array.Sort(niz, Telo.arraysort);
            return niz;
        }
        public static Telo[] dodaj(Telo[] stari_niz, float t)
        {
            Telo[] A = stari_niz;
            for (int p = 0; p < A.Length; p++)
            {
                A[p].X = A[p].kordinata(t);
            }
            return A;
        }
        public static Telo[] switcch(Telo[] stari, int kordinata_leva)
        {
            Telo[] A = stari;
            Telo smena = stari[kordinata_leva];
            stari[kordinata_leva] = stari[kordinata_leva + 1];
            stari[kordinata_leva + 1] = smena;
            return A;
        }
        public static Telo[] switcch_vise_tacaka(Telo[] stari, int kordinata_zadnja, int conter)
        {
            Telo[] A = stari;
            Telo[] smena = new Telo[conter + 1];
            Array.Copy(A, kordinata_zadnja - conter, smena, 0, conter + 1);
            Array.Sort(smena, Telo.arraysortV);
            Array.Copy(smena, 0, A, kordinata_zadnja - conter, conter + 1);
            return A;
        }
    }
    class Program
    {
        static int faktorial(int N)
        {
            if (N == 1) { return 1; }
            return N * faktorial(N - 1);
        }
        static int nCx(int N, int X)
        {
            if (X > N) { return 0; }
            return (faktorial(N) / (faktorial(N - X) * faktorial(X)));
        }
        static void Main(string[] args)//Napravi isto da i detektuje isti x pre ovoga i smanji K za tolko
        {
            string[] NK = Console.ReadLine().Split(' ');
            int N = int.Parse(NK[0]); int K = int.Parse(NK[1]);
            Telo[] tela = Telo.niz_create(N);
            float Ut = 0;//ukupno vreme
            int conter = 0;
            for (int p = 0; p < N - 1; p++) { if (tela[p].X == tela[p + 1].X) { conter++; } else { K -= nCx(conter + 1, 2); conter = 0; } }//Proverava situaciju da su tela pocela na istoj kordinati
            while (K > 0)
            {
                float MIN = float.MaxValue;//Vreme kandidat
                int p = -1;//ovde se cuvaju koordinate
                for (int e = 0; e < N - 1; e++)
                {
                    if (tela[e].V == tela[e + 1].V) { continue; }
                    float k = Telo.vreme_preticanja(tela[e], tela[e + 1]);
                    if (k == 0) { continue; }
                    if (k < MIN && k != -1) { MIN = k; p = e; }
                }
                Ut += MIN;
                tela = Telo.dodaj(tela, MIN);
                conter = 0;
                for (int i = 0; i < N - 1; i++)
                {
                    if (tela[i].X == tela[i + 1].X) { conter++; }
                    else
                    {
                        if (conter == 1) { K--; tela = Telo.switcch(tela, i - 1); }
                        else { K -= nCx(conter + 1, 2); Telo.switcch_vise_tacaka(tela, i, conter); }
                        conter = 0;
                    }
                }
                if (conter != 0)
                {
                    if (conter == 1) { K--; tela = Telo.switcch(tela, tela.Length - 2); }
                    else { K -= nCx(conter + 1, 2); Telo.switcch_vise_tacaka(tela, tela.Length - 1, conter); }
                    conter = 0;
                }
            }
            Console.WriteLine(Ut);
        }
    }
}